// GPA Test image 0 by mjh v2.0
// Creates an image with a central displaced section.

number ncols = 512
number ocol = ncols/2
number nrows = 512
number orow = nrows/2

image pic := realimage("GPA Test 0", 4, ncols, nrows)

number d = 15 // fringe spacing in pixels

number gx1 = 0      
number gy1 = 1/d	// reciprocal lattice vector gx,gy in pixels-1

number dPhase = -2.2   // constant phase term in radians

pic = tert(modulus(icol-ocol)<ncols/8, cos(2*Pi()*gy1*(orow-irow)), cos(2*Pi()*gy1*(orow-irow) + dPhase))

pic = pic + GaussianRandom()*0.5


showimage(pic)